/*
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *   Copyright (C) 2007  Benjamin Segovia <bsegovia@liris.cnrs.fr>
 */

#ifndef RT_BVH_H
#define RT_BVH_H

#include "specifics.h"
#include "math_aabb.h" // Axis-aligned bounding box
#include "rt_triangle_wald.h" // Accelerated structure for triangles

#include <vector>

namespace bvh {
    typedef uint32_t node_id_t;
    typedef uint32_t tri_id_t;
    struct node_t {
        /* Union is not necessary since we pad everything to 32 bytes */
        aabb_t aabb;
        node_id_t offset_flag;
        union {
            tri_id_t tri_id;
            uint32_t d;
        };
        FINLINE bool_t is_leaf() const {
            return offset_flag == 0;
        }
        FINLINE uint32_t get_offset() const {
            return offset_flag;
        }
        FINLINE const node_t *  __restrict get_children() const {
            return (const node_t * __restrict)
                ((const char * __restrict)this)[get_offset()];
        }
    };

    struct descriptor_t {
		node_t* root;
		std::vector<rt::wald_tri_t> acc;
    };
}
#endif

